using System;
using System.Collections;
using System.Collections.Generic;
using Server;
using Server.Items;

namespace Server.Mobiles
{
	public class Travesty : BaseCreature
	{
		private bool IsMLBoss;
		
      [Constructable]
		public Travesty() : this ( true )
		{
		}
		
      [Constructable]
		public Travesty( bool ismlboss ) : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			IsMLBoss = ismlboss;
         Name = "a travesty";
			Body = 0x108;

			SetStr( 171, 200 );
			SetDex( 126, 145 );
			SetInt( 276, 305 );

			SetHits( 7000, 7500 );

			SetDamage( 24, 28 );

			
			SetDamageType( ResistanceType.Cold, 40 );
			SetDamageType( ResistanceType.Energy, 60 );

			SetResistance( ResistanceType.Physical, 50, 60 );
			SetResistance( ResistanceType.Fire, 50, 60 );
			SetResistance( ResistanceType.Cold, 50, 60 );
			SetResistance( ResistanceType.Poison, 55, 65 );
			SetResistance( ResistanceType.Energy, 60, 70 );

			SetSkill( SkillName.Wrestling, 110.1, 119.7 );
			SetSkill( SkillName.Tactics, 112.3, 118.5 );
			SetSkill( SkillName.MagicResist, 111.2, 119.6 );
			SetSkill( SkillName.Anatomy, 110.1, 117.5 );
			Fame = 24000;
			Karma = -9000;

			VirtualArmor = 50;

// 			PackResources( 8 );
			PackItem( new RandomTalisman() );
			PackItem( new Tokens( Utility.RandomMinMax( 15, 25 ) ) );
		}

		public Travesty( Serial serial ) : base( serial )
		{
		}
		
		public override void OnKilledBy( Mobile mob )
		{
			base.OnKilledBy( mob );

			if ( IsMLBoss && Paragon.CheckArtifactChance( mob, this ) )
			{
				Paragon.GiveMLArtifactTo( mob );
			}
		}
		
		public override void OnDeath( Container c )
		{
			base.OnDeath( c );
         
			if ( IsMLBoss )
			{
				c.DropItem( new EyeOfTheTravesty() );
				c.DropItem( Loot.RandomArcanistScroll() );
         }
			
// 			c.DropItem( new EyeOfTheTravesty() );
// 			c.DropItem( new OrdersFromMinax() );
// 			
// 			switch ( Utility.Random( 3 ) )
// 			{
// 				case 0: c.DropItem( new TravestysSushiPreparations() ); break;
// 				case 1: c.DropItem( new TravestysFineTeakwoodTray() ); break;
// 				case 2: c.DropItem( new TravestysCollectionOfShells() ); break;
// 			}
			
// 			if ( Utility.RandomDouble() < 0.6 )				
// 				c.DropItem( new ParrotItem() );
			
// 			if ( Utility.RandomDouble() < 0.1 )
// 				c.DropItem( new TragicRemainsOfTravesty() );
// 				
// 			if ( Utility.RandomDouble() < 0.05 )
// 				c.DropItem( new ImprisonedDog() );
				
			if ( Utility.RandomDouble() < 0.04 )
				c.DropItem( new MarkOfTravesty() );
				
			if ( Utility.RandomDouble() < 0.01 )
				c.DropItem( new CrimsonCinture() );
		}
		
// 		public override bool CanAnimateDead{ get{ return true; } }
// 		public override BaseCreature Animates{ get{ return new LichLord(); } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }	
		public override bool BardImmune{ get{ return true; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool Uncalmable{ get{ return true; } }
		public override int TreasureMapLevel{ get{ return 5; } }
		private List<Item> m_Items;
		private Timer m_Timer;

// 		public override void OnThink()
// 		{
// 			base.OnThink();
// 			
// 			if ( Combatant == null )
// 				return;			
// 				
// 			if ( Combatant.Player && Name != Combatant.Name )
// 				Morph();	
// 		}
		
		public override void OnDamage( int amount, Mobile from, bool willKill, int typ )
		{
			base.OnDamage( amount, from, willKill, typ );
			if ( Hits < HitsMax * 0.5 && Utility.RandomDouble() < 0.05 )
				Spawn();
		}
		
// 		public override bool OnBeforeDeath()
// 		{
// 			if ( m_Items != null )
// 			{
// 				for ( int i = m_Items.Count - 1; i >= 0; i-- )
// 				{
// 					Item item = m_Items[ i ];
// 					
// 					if ( item != null )
// 						item.Delete();
// 				}
// 			}
// 			
// 			if ( m_Timer != null )
// 				m_Timer.Stop();			
// 				
// 			m_Timer = null;			
// 			Title = null;
// 			Name = "a travesty";
// 			Body = 0x108;
// 			Hue = 0;
// 			
// 			return base.OnBeforeDeath();
// 		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.SeSuperBoss, 2 );
		}		

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
		
// 		public virtual void Morph()
// 		{			
// 			Body = Combatant.Body; 
// 			Hue = Combatant.Hue; 
// 			Name = Combatant.Name;
// 			Title = Combatant.Title;
// 			Female = Combatant.Female;
// 			
// 			Item nItem;
// 			
// 			m_Items = new List<Item>();
//   				
// 			foreach ( Item item in Combatant.Items )
// 			{
// 				if ( item.Layer != Layer.Backpack && item.Layer != Layer.Mount )
// 				{
// 					nItem = CloneItem( item ); 
// 					AddItem( nItem );
// 					m_Items.Add( nItem );
// 				}
// 			}
// 			
// 			PlaySound( 0x511 );
// 			FixedParticles( 0x376A, 1, 14, 5045, EffectLayer.Waist );
// 			
// 			if ( m_Timer != null )
// 				m_Timer.Stop();
// 				
// 			FixedParticles( 0x376A, 1, 14, 0x13B5, EffectLayer.Waist );
// 			PlaySound( 0x511 );
// 
// 			
// 			Timer.DelayCall( TimeSpan.FromSeconds( 2 ), TimeSpan.FromSeconds( 2 ), 3, new TimerCallback( Clone ) );				
// 			m_Timer = Timer.DelayCall( TimeSpan.FromSeconds( 5 ), TimeSpan.FromSeconds( 5 ), new TimerCallback( EndMorph ) );
// 		}
// 
// 		public virtual Item CloneItem( Item item )
// 		{
// 			Item newItem = new Item( item.ItemID );
// 			
// 			newItem.Name = item.Name;			
// 			newItem.Hue = item.Hue;
// 			newItem.Layer = item.Layer;
// 
// 			return newItem;
// 		}
		
// 		public virtual void Clone()
// 		{
// 			new Clone( this ).MoveToWorld( Location, Map );
// 		}
// 		
// 		public virtual void EndMorph()
// 		{
// 			if ( Combatant != null && Name == Combatant.Name )
// 				return;
// 		
// 			if ( m_Items != null )
// 			{
// 				for ( int i = m_Items.Count - 1; i >= 0; i-- )
// 				{
// 					Item item = m_Items[ i ];
// 					
// 					if ( item != null )
// 						item.Delete();
// 				}
// 			}
// 			
// 			if ( m_Timer != null )
// 				m_Timer.Stop();			
// 				
// 			if ( Combatant != null )
// 			{
// 				Morph();
// 				
// 				return;
// 			}
// 				
// 			m_Timer = null;
// 			
// 			Title = null;
// 			Name = "a travesty";
// 			Body = 0x108;
// 			Hue = 0;
// 			
// 			PlaySound( 0x511 );
// 			FixedParticles( 0x376A, 1, 14, 5045, EffectLayer.Waist );
// 		}
		
		public virtual void Spawn()
		{
			for ( int i = 0; i < 10; i ++ )
				new SumNinja().MoveToWorld( Location, Map );
		}
	}
}
